/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.furniture;

import com.badlogic.gdx.graphics.Color;
import java.util.EnumMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;

public class FurnitureEntityAttributes
implements EntityAttributes {
    private long seed;
    private FurnitureType furnitureType;
    private EnumMap<GameMaterialType, GameMaterial> materials = new EnumMap(GameMaterialType.class);
    private GameMaterialType primaryMaterialType;
    private FurnitureLayout currentLayout;

    public FurnitureEntityAttributes(long seed) {
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public EntityAttributes clone() {
        FurnitureEntityAttributes cloned = new FurnitureEntityAttributes(this.seed);
        cloned.furnitureType = this.furnitureType;
        for (Map.Entry<GameMaterialType, GameMaterial> entry : this.materials.entrySet()) {
            cloned.materials.put((GameMaterialType)((Enum)entry.getKey()), entry.getValue());
        }
        cloned.primaryMaterialType = this.primaryMaterialType;
        cloned.currentLayout = this.currentLayout;
        return cloned;
    }

    @Override
    public Color getColor(ColoringLayer coloringLayer) {
        GameMaterialType materialType = coloringLayer.getLinkedMaterialType();
        if (materialType != null) {
            GameMaterial gameMaterial = this.materials.get((Object)materialType);
            if (gameMaterial != null) {
                return gameMaterial.getColor();
            }
            return null;
        }
        return null;
    }

    public FurnitureType getFurnitureType() {
        return this.furnitureType;
    }

    public void setFurnitureType(FurnitureType furnitureType) {
        this.furnitureType = furnitureType;
        this.currentLayout = furnitureType == null ? null : furnitureType.getDefaultLayout();
    }

    public EnumMap<GameMaterialType, GameMaterial> getMaterials() {
        return this.materials;
    }

    public void setMaterials(EnumMap<GameMaterialType, GameMaterial> materials) {
        this.materials = materials;
    }

    public GameMaterialType getPrimaryMaterialType() {
        return this.primaryMaterialType;
    }

    public void setPrimaryMaterialType(GameMaterialType primaryMaterialType) {
        this.primaryMaterialType = primaryMaterialType;
    }

    public FurnitureLayout getCurrentLayout() {
        return this.currentLayout;
    }

    public void setCurrentLayout(FurnitureLayout currentLayout) {
        this.currentLayout = currentLayout;
    }

    public String toString() {
        return "FurnitureEntityAttributes{furnitureType=" + this.furnitureType + ", primaryMaterialType=" + (Object)((Object)this.primaryMaterialType) + ", currentLayout=" + this.currentLayout + '}';
    }
}

